import request from '@/utils/request'

// 查询工厂报价列表
export function listFactoryQuote(query) {
  return request({
    url: '/qt/factoryQuote/list',
    method: 'get',
    params: query
  })
}

// 查询工厂报价详细
export function getFactoryQuote(id) {
  return request({
    url: '/qt/factoryQuote/' + id,
    method: 'get'
  })
}

// 新增工厂报价
export function addFactoryQuote(data) {
  return request({
    url: '/qt/factoryQuote',
    method: 'post',
    data: data
  })
}

// 修改工厂报价
export function updateFactoryQuote(data) {
  return request({
    url: '/qt/factoryQuote',
    method: 'put',
    data: data
  })
}

// 删除工厂报价
export function delFactoryQuote(id) {
  return request({
    url: '/qt/factoryQuote/' + id,
    method: 'delete'
  })
}
