import request from '@/utils/request'

// 查询刀模版领用单列表
export function listTmToolRequestUse(query) {
  return request({
    url: '/tm/tmToolRequestUse/list',
    method: 'get',
    params: query
  })
}

// 查询刀模版领用单详细
export function getTmToolRequestUse(toolRequestUseId) {
  return request({
    url: '/tm/tmToolRequestUse/' + toolRequestUseId,
    method: 'get'
  })
}

// 通过申请单id查询申请单刀模版数据
export function getTmToolRequestList(toolRequestId) {
  return request({
    url: 'tm/tmToolRequestUse/getToolsBytoolRequestId/' + toolRequestId,
    method: 'get'
  })
}

// 关联台账信息
export function getTmToolSnList(query) {
  return request({
    url: "/mes/tm/tool/list",
    method: "get",
    params: query
  });
}



// 新增刀模版领用单
export function addTmToolRequestUse(data) {
  return request({
    url: '/tm/tmToolRequestUse',
    method: 'post',
    data: data
  })
}

// 修改刀模版领用单
export function updateTmToolRequestUse(data) {
  return request({
    url: '/tm/tmToolRequestUse',
    method: 'put',
    data: data
  })
}

// 删除刀模版领用单
export function delTmToolRequestUse(toolRequestUseId) {
  return request({
    url: '/tm/tmToolRequestUse/' + toolRequestUseId,
    method: 'delete'
  })
}
