import request from "@/utils/request";

// 查询打样申请BOM列表
export function listPrototypeRequestBom(query) {
  return request({
    url: "/mes/pro/prototypeRequestBom/list",
    method: "get",
    params: query,
  });
}

// 查询打样申请BOM详细
export function getPrototypeRequestBom(bomItemId) {
  return request({
    url: "/mes/pro/prototypeRequestBom/" + bomItemId,
    method: "get",
  });
}

// 新增打样申请BOM
export function addPrototypeRequestBom(data) {
  return request({
    url: "/mes/pro/prototypeRequestBom",
    method: "post",
    data: data,
  });
}

// 修改打样申请BOM
export function updatePrototypeRequestBom(data) {
  return request({
    url: "/mes/pro/prototypeRequestBom",
    method: "put",
    data: data,
  });
}

// 删除打样申请BOM
export function delPrototypeRequestBom(bomItemId) {
  return request({
    url: "/mes/pro/prototypeRequestBom/" + bomItemId,
    method: "delete",
  });
}
