import request from '@/utils/request'

// 查询样品制作工序列表
export function listPrototypeMakeProcess(query) {
  return request({
    url: '/mes/pro/prototypeMakeProcess/list',
    method: 'get',
    params: query
  })
}

// 查询样品制作工序详细
export function getPrototypeMakeProcess(prototypeMakeProcessId) {
  return request({
    url: '/mes/pro/prototypeMakeProcess/' + prototypeMakeProcessId,
    method: 'get'
  })
}

// 新增样品制作工序
export function addPrototypeMakeProcess(data) {
  return request({
    url: '/mes/pro/prototypeMakeProcess',
    method: 'post',
    data: data
  })
}

// 修改样品制作工序
export function updatePrototypeMakeProcess(data) {
  return request({
    url: '/mes/pro/prototypeMakeProcess',
    method: 'put',
    data: data
  })
}

// 删除样品制作工序
export function delPrototypeMakeProcess(prototypeMakeProcessId) {
  return request({
    url: '/mes/pro/prototypeMakeProcess/' + prototypeMakeProcessId,
    method: 'delete'
  })
}
