import request from "@/utils/request";

// 查询样品制作单列表
export function listPrototypeMake(query) {
  return request({
    url: "/mes/pro/prototypeMake/list",
    method: "get",
    params: query,
  });
}

// 查询样品制作单详细
export function getPrototypeMake(prototypeMakeId) {
  return request({
    url: "/mes/pro/prototypeMake/" + prototypeMakeId,
    method: "get",
  });
}

// 新增样品制作单
export function addPrototypeMake(data) {
  return request({
    url: "/mes/pro/prototypeMake",
    method: "post",
    data: data,
  });
}

// 修改样品制作单
export function updatePrototypeMake(data) {
  return request({
    url: "/mes/pro/prototypeMake",
    method: "put",
    data: data,
  });
}

// 删除样品制作单
export function delPrototypeMake(prototypeMakeId) {
  return request({
    url: "/mes/pro/prototypeMake/" + prototypeMakeId,
    method: "delete",
  });
}
// 修改状态
export function dofinish(data) {
  return request({
    url: "/mes/pro/prototypeMake/modifyState/",
    method: "put",
    data: data,
  });
}
