import request from '@/utils/request'

// 查询工作中心列表
export function listWorkstation(query) {
  return request({
    url: '/mes/md/workstation/list',
    method: 'get',
    params: query
  })
}

// 查询工作中心详细
export function getWorkstation(workstationId) {
  return request({
    url: '/mes/md/workstation/' + workstationId,
    method: 'get'
  })
}

// 新增工作中心
export function addWorkstation(data) {
  return request({
    url: '/mes/md/workstation',
    method: 'post',
    data: data
  })
}

// 修改工作中心
export function updateWorkstation(data) {
  return request({
    url: '/mes/md/workstation',
    method: 'put',
    data: data
  })
}

// 删除工作中心
export function delWorkstation(workstationId) {
  return request({
    url: '/mes/md/workstation/' + workstationId,
    method: 'delete'
  })
}
