import request from '@/utils/request'

// 查询派车记录列表
export function listVehicleDispatch(query) {
  return request({
    url: '/md/vehicleDispatch/list',
    method: 'get',
    params: query
  })
}

// 查询派车记录详细
export function getVehicleDispatch(dispatchId) {
  return request({
    url: '/md/vehicleDispatch/' + dispatchId,
    method: 'get'
  })
}

// 新增派车记录
export function addVehicleDispatch(data) {
  return request({
    url: '/md/vehicleDispatch',
    method: 'post',
    data: data
  })
}

// 修改派车记录
export function updateVehicleDispatch(data) {
  return request({
    url: '/md/vehicleDispatch',
    method: 'put',
    data: data
  })
}

// 删除派车记录
export function delVehicleDispatch(dispatchId) {
  return request({
    url: '/md/vehicleDispatch/' + dispatchId,
    method: 'delete'
  })
}
