import request from '@/utils/request'

// 查询客户SAP特性信息列表
export function listData(query) {
  return request({
    url: '/md/sapPropertyData/list',
    method: 'get',
    params: query
  })
}

// 查询客户SAP特性信息详细
export function getData(id) {
  return request({
    url: '/md/sapPropertyData/' + id,
    method: 'get'
  })
}

// 新增客户SAP特性信息
export function addData(data) {
  return request({
    url: '/md/sapPropertyData',
    method: 'post',
    data: data
  })
}

// 修改客户SAP特性信息
export function updateData(data) {
  return request({
    url: '/md/sapPropertyData',
    method: 'put',
    data: data
  })
}

// 删除客户SAP特性信息
export function delData(id) {
  return request({
    url: '/md/sapPropertyData/' + id,
    method: 'delete'
  })
}
