import request from '@/utils/request'

// 查询Sap特性视图详细
export function get(params) {
  return request({
    url: '/md/sapFieldData/',
    method: 'get',
    params
  })
}

// 查询Sap特性视图列表
export function page(data) {
  return request({
    url: '/md/sapFieldData/page',
    method: 'post',
    data
  })
}

// 查询Sap特性视图列表
export function listView(query) {
  return request({
    url: '/md/sapFieldData/list',
    method: 'get',
    params: query
  })
}

// 查询Sap特性视图列表
export function listViewVo(query) {
  return request({
    url: '/md/sapFieldData/listVo',
    method: 'get',
    params: query
  })
}

// 新增Sap特性视图
export function addView(data) {
  return request({
    url: '/md/sapFieldData',
    method: 'post',
    data: data
  })
}

// 修改Sap特性视图
export function updateView(data) {
  return request({
    url: '/md/sapFieldData',
    method: 'put',
    data: data
  })
}

// 删除Sap特性视图
export function delView(id) {
  return request({
    url: '/md/sapFieldData/' + id,
    method: 'delete'
  })
}
