import request from '@/utils/request'

// 查询销售订单组织列表
export function listOrg(query) {
  return request({
    url: '/md/org/list',
    method: 'get',
    params: query
  })
}

// 查询销售订单组织详细
export function getOrg(id) {
  return request({
    url: '/md/org/' + id,
    method: 'get'
  })
}

// 新增销售订单组织
export function addOrg(data) {
  return request({
    url: '/md/org',
    method: 'post',
    data: data
  })
}

// 修改销售订单组织
export function updateOrg(data) {
  return request({
    url: '/md/org',
    method: 'put',
    data: data
  })
}

// 删除销售订单组织
export function delOrg(id) {
  return request({
    url: '/md/org/' + id,
    method: 'delete'
  })
}
