import request from '@/utils/request'

// 查询产品打样排版参数配置列表
export function listConf(query) {
  return request({
    url: '/md/conf/list',
    method: 'get',
    params: query
  })
}

// 查询产品打样排版参数配置详细
export function getConf(productPublishedConfId) {
  return request({
    url: '/md/conf/' + productPublishedConfId,
    method: 'get'
  })
}

// 新增产品打样排版参数配置
export function addConf(data) {
  return request({
    url: '/md/conf',
    method: 'post',
    data: data
  })
}

// 修改产品打样排版参数配置
export function updateConf(data) {
  return request({
    url: '/md/conf',
    method: 'put',
    data: data
  })
}

// 删除产品打样排版参数配置
export function delConf(productPublishedConfId) {
  return request({
    url: '/md/conf/' + productPublishedConfId,
    method: 'delete'
  })
}
