import request from '@/utils/request'

// 查询产品基本信息列表
export function listInfo(query) {
  return request({
    url: '/md/info/list',
    method: 'get',
    params: query
  })
}

// 查询产品基本信息详细
export function getInfo(itemId) {
  return request({
    url: '/md/info/' + itemId,
    method: 'get'
  })
}

// 新增产品基本信息
export function addInfo(data) {
  return request({
    url: '/md/info',
    method: 'post',
    data: data
  })
}

// 修改产品基本信息
export function updateInfo(data) {
  return request({
    url: '/md/info',
    method: 'put',
    data: data
  })
}

// 删除产品基本信息
export function delInfo(baseInfoId) {
  return request({
    url: '/md/info/' + baseInfoId,
    method: 'delete'
  })
}
