import {listChannel} from '@/api/mes/md/saleOrder/channel'
import {listGroup} from '@/api/mes/md/saleOrder/group'
import {listOffice} from '@/api/mes/md/saleOrder/office'
import {listOrg} from '@/api/mes/md/saleOrder/org'
import {listType} from '@/api/mes/md/saleOrder/type'
import {listUnit} from '@/api/mes/md/unit'
import {listClause} from '@/api/mes/md/clause'
import {listCurrency} from '@/api/mes/md/currency'
import {listReason} from '@/api/mes/md/reason'
import {listPoint} from '@/api/mes/md/point'
import {listClause as listPaymentClause } from '@/api/mes/md/paymentClause'
const order = {
  namespaced: true,
  state: {
    saleChannel: [],
    saleGroup: [],
    saleOffice: [],
    saleOrg: [],
    saleType: [],
    saleUnit: [],
    saleClause: [],
    saleCurrency: [],
    salePaymentClause: [],
    saleReason: [],
    saleShipmentPoint: [],
  },

  mutations: {
    SET_SALE_CHANNEL(state, data) {
      state.saleChannel = data
    },
    SET_SALE_GROUP(state, data) {
      state.saleGroup = data
    },
    SET_SALE_OFFICE(state, data) {
      state.saleOffice = data
    },
    SET_SALE_ORG(state, data) {
      state.saleOrg = data
    },
    SET_SALE_TYPE(state, data) {
      state.saleType = data
    },
    SET_SALE_UNIT(state, data) {
      state.saleUnit = data
    },
    SET_SALE_CLAUSE(state, data) {
      state.saleClause = data
    },
    SET_SALE_CURRENCY(state, data) {
      state.saleCurrency = data
    },
    SET_SALE_PAYMENT_CLAUSE(state, data) {
      state.salePaymentClause = data
    },
    SET_SALE_REASON(state, data) {
      state.saleReason = data
    },
    SET_SALE_SHIPMENT_POINT(state, data) {
      state.saleShipmentPoint = data
    },
  },

  actions: {
    getSaleChannel({commit, state}) {
      return new Promise((resolve, reject) => {
        if (state.saleChannel && state.saleChannel.length) return resolve(state.saleChannel)
        listChannel().then(res => {
          commit('SET_SALE_CHANNEL', res.rows)
          resolve(res.rows)
        }).catch(() => reject())
      })
    },
    getSaleGroup({commit, state}) {
      return new Promise((resolve, reject) => {
        if (state.saleGroup && state.saleGroup.length) return resolve(state.saleGroup)
        listGroup().then(res => {
          commit('SET_SALE_GROUP', res.rows)
          resolve(res.rows)
        }).catch(() => reject())
      })
    },
    getSaleOffice({commit, state}) {
      return new Promise((resolve, reject) => {
        if (state.saleOffice && state.saleOffice.length) return resolve(state.saleOffice)
        listOffice().then(res => {
          commit('SET_SALE_OFFICE', res.rows)
          resolve(res.rows)
        }).catch(() => reject())
      })
    },
    getSaleOrg({commit, state}) {
      return new Promise((resolve, reject) => {
        if (state.saleOrg && state.saleOrg.length) return resolve(state.saleOrg)
        listOrg().then(res => {
          commit('SET_SALE_ORG', res.rows)
          resolve(res.rows)
        }).catch(() => reject())
      })
    },
    getSaleType({commit, state}) {
      return new Promise((resolve, reject) => {
        if (state.saleType && state.saleType.length) return resolve(state.saleType)
        listType().then(res => {
          commit('SET_SALE_TYPE', res.rows)
          resolve(res.rows)
        }).catch(() => reject())
      })
    },
    getSaleUnit({commit, state}) {
      return new Promise((resolve, reject) => {
        if (state.saleUnit && state.saleUnit.length) return resolve(state.saleUnit)
        listUnit().then(res => {
          commit('SET_SALE_UNIT', res.rows)
          resolve(res.rows)
        }).catch(() => reject())
      })
    },
    getSaleClause({commit, state}) {
      return new Promise((resolve, reject) => {
        if (state.saleClause && state.saleClause.length) return resolve(state.saleClause)
        listClause().then(res => {
          commit('SET_SALE_CLAUSE', res.rows)
          resolve(res.rows)
        }).catch(() => reject())
      })
    },
    getSaleCurrency({commit, state}) {
      return new Promise((resolve, reject) => {
        if (state.saleCurrency && state.saleCurrency.length) return resolve(state.saleCurrency)
        listCurrency().then(res => {
          commit('SET_SALE_CURRENCY', res.rows)
          resolve(res.rows)
        }).catch(() => reject())
      })
    },
    getSalePaymentClause({commit, state}) {
      return new Promise((resolve, reject) => {
        if (state.salePaymentClause && state.salePaymentClause.length) return resolve(state.salePaymentClause)
        listReason().then(res => {
          commit('SET_SALE_PAYMENT_CLAUSE', res.rows)
          resolve(res.rows)
        }).catch(() => reject())
      })
    },
    getSaleReason({commit, state}) {
      return new Promise((resolve, reject) => {
        if (state.saleReason && state.saleReason.length) return resolve(state.saleReason)
        listPoint().then(res => {
          commit('SET_SALE_REASON', res.rows)
          resolve(res.rows)
        }).catch(() => reject())
      })
    },
    getSaleShipmentPoint({commit, state}) {
      return new Promise((resolve, reject) => {
        if (state.saleShipmentPoint && state.saleShipmentPoint.length) return resolve(state.saleShipmentPoint)
        listPaymentClause().then(res => {
          commit('SET_SALE_SHIPMENT_POINT', res.rows)
          resolve(res.rows)
        }).catch(() => reject())
      })
    },
  }
}

export default order
