import request from '@/utils/request'

// 查询销售订单付款条件列表
export function listClause(query) {
  return request({
    url: '/md/payment/list',
    method: 'get',
    params: query
  })
}

// 查询销售订单付款条件详细
export function getClause(id) {
  return request({
    url: '/md/payment/' + id,
    method: 'get'
  })
}

// 新增销售订单付款条件
export function addClause(data) {
  return request({
    url: '/md/payment',
    method: 'post',
    data: data
  })
}

// 修改销售订单付款条件
export function updateClause(data) {
  return request({
    url: '/md/payment',
    method: 'put',
    data: data
  })
}

// 删除销售订单付款条件
export function delClause(id) {
  return request({
    url: '/md/clause/' + id,
    method: 'delete'
  })
}
