import request from '@/utils/request'

// 查询检测模板-工序列表
export function listTemplateProcess(query) {
  return request({
    url: '/mes/qc/templateProcess/list',
    method: 'get',
    params: query
  })
}

// 查询检测模板-工序详细
export function getTemplateProcess(recordId) {
  return request({
    url: '/mes/qc/templateProcess/' + recordId,
    method: 'get'
  })
}

// 获取是否选项
export function newProduct(recordId) {
  return request({
    url: 'mes/qc/templateProcess/getDictList/newProduct',
    method: 'get'
  })
}

// 新增检测模板-工序
export function addTemplateProcess(data) {
  return request({
    url: '/mes/qc/templateProcess',
    method: 'post',
    data: data
  })
}

// 修改检测模板-工序
export function updateTemplateProcess(data) {
  return request({
    url: '/mes/qc/templateProcess',
    method: 'put',
    data: data
  })
}

// 删除检测模板-工序
export function delTemplateProcess(recordId) {
  return request({
    url: '/mes/qc/templateProcess/' + recordId,
    method: 'delete'
  })
}
