import request from '@/utils/request'

// 查询排产换型对照信息列表
export function listScheduleSetupRule(query) {
  return request({
    url: '/pro/scheduleSetupRule/list',
    method: 'get',
    params: query
  })
}

// 查询排产换型对照信息详细
export function getScheduleSetupRule(ruleId) {
  return request({
    url: '/pro/scheduleSetupRule/' + ruleId,
    method: 'get'
  })
}

// 新增排产换型对照信息
export function addScheduleSetupRule(data) {
  return request({
    url: '/pro/scheduleSetupRule',
    method: 'post',
    data: data
  })
}

// 修改排产换型对照信息
export function updateScheduleSetupRule(data) {
  return request({
    url: '/pro/scheduleSetupRule',
    method: 'put',
    data: data
  })
}

// 删除排产换型对照信息
export function delScheduleSetupRule(ruleId) {
  return request({
    url: '/pro/scheduleSetupRule/' + ruleId,
    method: 'delete'
  })
}
