import request from "@/utils/request";

// 查询打样申请列表
export function listPrototypeRequest(query) {
  return request({
    url: "/mes/pro/prototypeRequest/list",
    method: "get",
    params: query,
  });
}

// 查询打样申请详细
export function getPrototypeRequest(prototypeRequestId) {
  return request({
    url: "/mes/pro/prototypeRequest/" + prototypeRequestId,
    method: "get",
  });
}

// 新增打样申请
export function addPrototypeRequest(data) {
  return request({
    url: "/mes/pro/prototypeRequest",
    method: "post",
    data: data,
  });
}

// 修改打样申请
export function updatePrototypeRequest(data) {
  return request({
    url: "/mes/pro/prototypeRequest",
    method: "put",
    data: data,
  });
}

// 删除打样申请
export function delPrototypeRequest(prototypeRequestId) {
  return request({
    url: "/mes/pro/prototypeRequest/" + prototypeRequestId,
    method: "delete",
  });
}

// 修改状态
export function dofinish(data) {
  return request({
    url: "/mes/pro/prototypeRequest/modifyState/",
    method: "put",
    data: data,
  });
}
