import request from '@/utils/request'

// 查询生产组合单列表
export function listCombination(query) {
  return request({
    url: '/pro/combination/list',
    method: 'get',
    params: query
  })
}

// 查询生产组合单列表
export function combList(query) {
  return request({
    url: '/pro/combination/combList',
    method: 'get',
    params: query
  })
}


// 查询生产组合单详细
export function getCombination(combinationId) {
  return request({
    url: '/pro/combination/' + combinationId,
    method: 'get'
  })
}

// 新增生产组合单
export function addCombination(data) {
  return request({
    url: '/pro/combination',
    method: 'post',
    data: data
  })
}

// 新增生产组合单
export function batchAddCombination(data) {
  return request({
    url: '/pro/combination/batchAdd',
    method: 'post',
    data: data
  })
}

// 生产组合单-新增-追加组合单
export function insertCombination(data) {
  return request({
    url: '/pro/combination/insert',
    method: 'post',
    data: data
  })
}

// 新增生产组合单
export function batchAddCombinations(data) {
  return request({
    url: '/pro/combination/batchAdd2',
    method: 'post',
    data: data
  })
}




// 修改生产组合单
export function updateCombination(data) {
  return request({
    url: '/pro/combination',
    method: 'put',
    data: data
  })
}

// 删除生产组合单
export function delCombination(combinationId) {
  return request({
    url: '/pro/combination/' + combinationId,
    method: 'delete'
  })
}
