import request from '@/utils/request'

// 查询生产BOM组件列表
export function listBomItem(query) {
  return request({
    url: '/mes/pro/bomItem/list',
    method: 'get',
    params: query
  })
}

// 查询生产BOM组件详细
export function getBomItem(bomItemId) {
  return request({
    url: '/mes/pro/bomItem/' + bomItemId,
    method: 'get'
  })
}

// 新增生产BOM组件
export function addBomItem(data) {
  return request({
    url: '/mes/pro/bomItem',
    method: 'post',
    data: data
  })
}

// 修改生产BOM组件
export function updateBomItem(data) {
  return request({
    url: '/mes/pro/bomItem',
    method: 'put',
    data: data
  })
}

// 删除生产BOM组件
export function delBomItem(bomItemId) {
  return request({
    url: '/mes/pro/bomItem/' + bomItemId,
    method: 'delete'
  })
}
