import request from '@/utils/request'

// 查询车辆列表列表
export function listVehicle(query) {
  return request({
    url: '/md/vehicle/list',
    method: 'get',
    params: query
  })
}

// 查询车辆列表详细
export function getVehicle(vehicleId) {
  return request({
    url: '/md/vehicle/' + vehicleId,
    method: 'get'
  })
}

// 新增车辆列表
export function addVehicle(data) {
  return request({
    url: '/md/vehicle',
    method: 'post',
    data: data
  })
}

// 修改车辆列表
export function updateVehicle(data) {
  return request({
    url: '/md/vehicle',
    method: 'put',
    data: data
  })
}

// 删除车辆列表
export function delVehicle(vehicleId) {
  return request({
    url: '/md/vehicle/' + vehicleId,
    method: 'delete'
  })
}
