import request from '@/utils/request'

// 查询排产日志列表
export function listScheduleLog(query) {
  return request({
    url: '/pro/scheduleLog/list',
    method: 'get',
    params: query
  })
}

// 查询排产日志详细
export function getScheduleLog(id) {
  return request({
    url: '/pro/scheduleLog/' + id,
    method: 'get'
  })
}

// 新增排产日志
export function addScheduleLog(data) {
  return request({
    url: '/pro/scheduleLog',
    method: 'post',
    data: data
  })
}

// 修改排产日志
export function updateScheduleLog(data) {
  return request({
    url: '/pro/scheduleLog',
    method: 'put',
    data: data
  })
}

// 删除排产日志
export function delScheduleLog(id) {
  return request({
    url: '/pro/scheduleLog/' + id,
    method: 'delete'
  })
}
