import request from '@/utils/request'

// 查询领料申请列表体
export function listMaterialRequest(query) {
  return request({
    url: '/pro/materialRequest/list',
    method: 'get',
    params: query
  })
}

// 查询领料申请列表头
export function listMaterialRequests(query) {
  return request({
    url: '/pro/materialRequest/lists',
    method: 'get',
    params: query
  })
}


// 查询领料申请详细
export function getMaterialRequest(materialRequestId) {
  return request({
    url: '/pro/materialRequest/' + materialRequestId,
    method: 'get'
  })
}

// 新增领料申请
export function addMaterialRequest(data) {
  return request({
    url: '/pro/materialRequest',
    method: 'post',
    data: data
  })
}

// 打印领料申请
export function materialRequestPrintInfo(data) {
  return request({
    url: '/pro/materialRequest/materialRequestPrintInfo',
    method: 'get',
    params: data
  })
}

// 修改领料申请
export function updateMaterialRequest(data) {
  return request({
    url: '/pro/materialRequest',
    method: 'put',
    data: data
  })
}

// 删除领料申请
export function delMaterialRequest(materialRequestId) {
  return request({
    url: '/pro/materialRequest/' + materialRequestId,
    method: 'delete'
  })
}

// 确认补货按钮
export function confirmMaterialRequest(applyNo) {
  return request({
    url:  '/pro/materialRequest/confirm/' + applyNo,
    method: 'get',
  })
}
