import request from '@/utils/request'

// 查询量产制作工序列表
export function listProductionMakeProcess(query) {
  return request({
    url: '/md/productionMakeProcess/list',
    method: 'get',
    params: query
  })
}

// 查询量产制作工序详细
export function getProductionMakeProcess(productionMakeProcessId) {
  return request({
    url: '/md/productionMakeProcess/' + productionMakeProcessId,
    method: 'get'
  })
}

// 新增量产制作工序
export function addProductionMakeProcess(data) {
  return request({
    url: '/md/productionMakeProcess',
    method: 'post',
    data: data
  })
}

// 修改量产制作工序
export function updateProductionMakeProcess(data) {
  return request({
    url: '/md/productionMakeProcess',
    method: 'put',
    data: data
  })
}

// 删除量产制作工序
export function delProductionMakeProcess(productionMakeProcessId) {
  return request({
    url: '/md/productionMakeProcess/' + productionMakeProcessId,
    method: 'delete'
  })
}
