import request from '@/utils/request'

// 查询打样申请工序列表
export function listPrototypeRequestProcess(query) {
  return request({
    url: '/mes/pro/PrototypeRequestProcess/list',
    method: 'get',
    params: query
  })
}

// 查询打样申请工序详细
export function getPrototypeRequestProcess(prototypeRequestProcessId) {
  return request({
    url: '/mes/pro/PrototypeRequestProcess/' + prototypeRequestProcessId,
    method: 'get'
  })
}

// 新增打样申请工序
export function addPrototypeRequestProcess(data) {
  return request({
    url: '/mes/pro/PrototypeRequestProcess',
    method: 'post',
    data: data
  })
}

// 修改打样申请工序
export function updatePrototypeRequestProcess(data) {
  return request({
    url: '/mes/pro/PrototypeRequestProcess',
    method: 'put',
    data: data
  })
}

// 删除打样申请工序
export function delPrototypeRequestProcess(prototypeRequestProcessId) {
  return request({
    url: '/mes/pro/PrototypeRequestProcess/' + prototypeRequestProcessId,
    method: 'delete'
  })
}
