import request from "@/utils/request";

// 查询生产任务列表
export function listProtask(query) {
  return request({
    url: "/mes/pro/protask/list",
    method: "get",
    params: query,
  });
}

// 查询生产任务列表
export function listGanttTaskList(query) {
  return request({
    url: "/mes/pro/protask/listGanttTaskList",
    method: "get",
    params: query,
  });
}

// 查询生产任务列表加上了字段workunitName
export function listTaskListDetail(query) {
  return request({
    url: "/mes/pro/protask/listDetail",
    method: "get",
    params: query,
  });
}
// 查询根据任务id获取刀模板
export function getTaskIdMaxProcessTool(query) {
  return request({
    url: `/mes/pro/protask/getMaxProcessTool/${query.taskId}`,
    method: "get",
    params: query,
  });
}

// 查询生产任务详细
export function getProtask(taskId) {
  return request({
    url: "/mes/pro/protask/" + taskId,
    method: "get",
  });
}

// 新增生产任务
export function addProtask(data) {
  return request({
    url: "/mes/pro/protask",
    method: "post",
    data: data,
  });
}

// 修改生产任务
export function updateProtask(data) {
  return request({
    url: "/mes/pro/protask",
    method: "put",
    data: data,
  });
}

// 删除生产任务
export function delProtask(taskId) {
  return request({
    url: "/mes/pro/protask/" + taskId,
    method: "delete",
  });
}

// 生成任务单、合并任务单
export function addProtaskList(workorderIds) {
  return request({
    url: "/mes/pro/protask/" + workorderIds,
    method: "post",
  });
}
