import request from '@/utils/request'
import { parseStrEmpty } from "@/utils/ruoyi";

// 查询用户列表
export function listUser(query) {
  return request({
    url: '/system/user/list',
    method: 'get',
    params: query
  })
}

// 查询用户详细
export function getUser(userId) {
  return request({
    url: '/system/user/' + parseStrEmpty(userId),
    method: 'get'
  })
}

// 新增用户
export function addUser(data) {
  return request({
    url: '/system/user',
    method: 'post',
    data: data
  })
}

// 修改用户
export function updateUser(data) {
  return request({
    url: '/system/user',
    method: 'put',
    data: data
  })
}

// 删除用户
export function delUser(userId) {
  return request({
    url: '/system/user/' + userId,
    method: 'delete'
  })
}

// 用户密码重置
export function resetUserPwd(userId, password) {
  const data = {
    userId,
    password
  }
  return request({
    url: '/system/user/resetPwd',
    method: 'put',
    data: data
  })
}

// 用户状态修改
export function changeUserStatus(userId, status) {
  const data = {
    userId,
    status
  }
  return request({
    url: '/system/user/changeStatus',
    method: 'put',
    data: data
  })
}

// 查询用户个人信息
export function getUserProfile() {
  return request({
    url: '/system/user/profile',
    method: 'get'
  })
}

// 修改用户个人信息
export function updateUserProfile(data) {
  return request({
    url: '/system/user/profile',
    method: 'put',
    data: data
  })
}

// 用户密码重置
export function updateUserPwd(oldPassword, newPassword) {
  const data = {
    oldPassword,
    newPassword
  }
  return request({
    url: '/system/user/profile/updatePwd',
    method: 'put',
    params: data
  })
}

// 用户头像上传
export function uploadAvatar(data) {
  return request({
    url: '/system/user/profile/avatar',
    method: 'post',
    data: data
  })
}

// 查询授权角色
export function getAuthRole(userId) {
  return request({
    url: '/system/user/authRole/' + userId,
    method: 'get'
  })
}

// 保存授权角色
export function updateAuthRole(data) {
  return request({
    url: '/system/user/authRole',
    method: 'put',
    params: data
  })
}


// 同步bpm人员数据
export function getBpmUser() {
  return request({
    url: '/system/usermanage/userManageCreate',
    method: 'post',
  })
}

// 查询人工作单元列表
export function listWorkunituser(query) {
  return request({
    url: '/mes/md/workunitWorker/list',
    method: 'get',
    params: query
  })
}

// 查询人工作单元
export function getWorkunituser(recordId) {
  return request({
    url: '/mes/md/workunitWorker/' + recordId,
    method: 'get'
  })
}

// 新增人工作单元
export function addWorkunituser(data) {
  return request({
    url: '/mes/md/workunitWorker',
    method: 'post',
    data: data
  })
}

// 修改人工作单元
export function updateWorkunituser(data) {
  return request({
    url: '/mes/md/workunitWorker',
    method: 'put',
    data: data
  })
}

// 删除人工作单元
export function delWorkunituser(recordId) {
  return request({
    url: '/mes/md/workunitWorker/' + recordId,
    method: 'delete'
  })
}

// 查询工作单元，排除已绑定的
export function listByUser(query) {
  return request({
    url: '/mes/md/workunitWorker/listByUser',
    method: 'get',
    params: query
  })
}

// 修改人工作单元
export function updateWorkunituserList(query) {
  return request({
    url: '/mes/md/workunitWorker/workunit',
    method: 'put',
    data: query
  })
}
