import apiHelper from './api.helper.js'

/**
 * 登录服务
 * @param 
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiLogin(params) {
	const res = await apiHelper.post('/crm-app/login', params, {
		'Content-Type': "application/x-www-form-urlencoded"
	})
	return res
}

/**
 * 登出服务
 * @param 
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiLogOut(params) {
	const res = await apiHelper.post('/crm-app/logout', params, {
		'Content-Type': "application/x-www-form-urlencoded"
	})
	return res
}

export default {
	apiLogin
}
