import {
	deepMerge
} from "@/utils/index.js";
import validate from "@/utils/validate.js";
import {
	Base64
} from 'js-base64'
import store from '@/store/index.js'

class Request {
	// 设置全局默认配置
	setConfig(customConfig) {
		// 深度合并对象，否则会造成对象深层属性丢失
		this.config = deepMerge(this.config, customConfig);
	}

	// 主要请求部分
	request(options = {}) {

		// 检查请求拦截
		if (this.interceptor.request && typeof this.interceptor.request === 'function') {
			let tmpConfig = {};
			let interceptorRequest = this.interceptor.request(options);
			if (interceptorRequest === false) {
				// 返回一个处于pending状态中的Promise，来取消原promise，避免进入then()回调
				return new Promise(() => {});
			}
			this.options = interceptorRequest;
		}

		options.dataType = options.dataType || this.config.dataType;
		options.responseType = options.responseType || this.config.responseType;
		options.url = options.url || '';
		options.params = options.params || {};
		options.header = Object.assign({}, this.config.header, options.header);
		options.method = options.method || this.config.method;
		options.sslVerify = false

		// console.log('api.helper-----request', options, this.options)

		return new Promise((resolve, reject) => {
			options.complete = (response) => {
				console.log('api.helper---options.complete', response)
				// 请求返回后，隐藏loading(如果请求返回快的话，可能会没有loading)
				uni.hideLoading();
				// 清除定时器，如果请求回来了，就无需loading
				clearTimeout(this.config.timer);
				this.config.timer = null;
				// 判断用户对拦截返回数据的要求，如果originalData为true，返回所有的数据(response)到拦截器，否则只返回response.data
				if (this.config.originalData) {
					// 判断是否存在拦截器
					if (this.interceptor.response && typeof this.interceptor.response === 'function') {
						let resInterceptors = this.interceptor.response(response);
						// 如果拦截器不返回false，就将拦截器返回的内容给this.$u.post的then回调
						if (resInterceptors !== false) {
							resolve(resInterceptors);
						} else {
							// 如果拦截器返回false，意味着拦截器定义者认为返回有问题，直接接入catch回调
							reject(response);
						}
					} else {
						// 如果要求返回原始数据，就算没有拦截器，也返回最原始的数据
						resolve(response);
					}
				} else {
					if (response.statusCode == 200) {
						if (this.interceptor.response && typeof this.interceptor.response ===
							'function') {
							let resInterceptors = this.interceptor.response(response.data);
							if (resInterceptors !== false) {
								resolve(resInterceptors);
							} else {
								reject(response.data);
							}
						} else {
							// 如果不是返回原始数据(originalData=false)，且没有拦截器的情况下，返回纯数据给then回调
							resolve(response.data);
						}
					} else {
						// 不返回原始数据的情况下，服务器状态码不为200，modal弹框提示
						// if(response.errMsg) {
						// 	uni.showModal({
						// 		title: response.errMsg
						// 	});
						// }
						if (response.statusCode == 500) {
							uni.showToast({
								title: '服务器异常',
								duration: 2000,
								icon: 'none'
							})
						}
						if (response.statusCode == 401) {
							uni.showToast({
								title: '登录已失效',
								duration: 2000,
								icon: 'none'
							})
							uni.navigateTo({
								url: "/pages/login/login"
							})
						}
						reject(response)
					}
				}
			}

			// 判断用户传递的URL是否/开头,如果不是,加上/，这里使用了uView的test.js验证库的url()方法
			options.url = validate.url(options.url) ? options.url : ((options.baseUrl ? options.baseUrl :
				this
				.config.baseUrl) + (options.url
				.indexOf('/') == 0 ?
				options.url : '/' + options.url));

			// 是否显示loading
			// 加一个是否已有timer定时器的判断，否则有两个同时请求的时候，后者会清除前者的定时器id
			// 而没有清除前者的定时器，导致前者超时，一直显示loading
			if (this.config.showLoading && !this.config.timer) {
				this.config.timer = setTimeout(() => {
					uni.showLoading({
						title: this.config.loadingText,
						mask: this.config.loadingMask
					})
					this.config.timer = null;
				}, this.config.loadingTime);
			}
			// console.log('api.helper-----finally***request', options)
			uni.request(options);
		})
		// .catch(res => {
		// 	// 如果返回reject()，不让其进入this.$u.post().then().catch()后面的catct()
		// 	// 因为很多人都会忘了写后面的catch()，导致报错捕获不到catch
		// 	return new Promise(()=>{});
		// })
	}

	constructor() {
		this.config = {
			baseUrl: 'http://221.10.127.60:5000', // 请求的根域名
			// 默认的请求头
			header: {},
			method: 'POST',
			// 设置为json，返回后uni.request会对数据进行一次JSON.parse
			dataType: 'json',
			// 此参数无需处理，因为5+和支付宝小程序不支持，默认为text即可
			responseType: 'text',
			showLoading: true, // 是否显示请求中的loading
			loadingText: '请求中...',
			loadingTime: 800, // 在此时间内，请求还没回来的话，就显示加载中动画，单位ms
			timer: null, // 定时器
			sslVerify: false, // 定时器
			originalData: false, // 是否在拦截器中返回服务端的原始数据，见文档说明
			loadingMask: true, // 展示loading的时候，是否给一个透明的蒙层，防止触摸穿透
		}

		// 拦截器
		this.interceptor = {
			// 请求前的拦截
			request: (config) => {
				config.header['Authorization'] = `Basic ${Base64.encode('wangpc:LZY888@@')}`;
				try {
					if (config.url.indexOf('crm-app/login') === -
						1 &&
						store.state.vuex_token) {
						config.header['X-Auth-Token'] = store
							.state.vuex_token
					}

					if (config.header['Content-Type'] && config.header['Content-Type'].indexOf(
							'x-www-form-urlencoded') === -1) {
						config.header['Content-Type'] = "application/json; charset=utf-8"
					}


					if (config.url.indexOf('crm-app') !== -1) {
						// config.baseUrl = 'http://10.0.135.61'
						config.baseUrl = 'http://221.10.127.60:5000'
					} else if (config.url.indexOf('adapter') !== -1) {
						config.baseUrl = 'http://api.c0331.dev.guanyingyun.com'
						// config.baseUrl = 'http://221.10.127.60:5000/cyj'
					} else if (config.url.indexOf('wmdpwebservices') !== -1) {
						// config.baseUrl = 'https://10.0.134.182:9002'
						config.baseUrl = 'http://221.10.127.60:5000/sczx'
						// config.baseUrl = ''
					} else {
						config.baseUrl = 'http://221.10.127.60:5000/wlySap'
					}
				} catch (e) {
					console.log('error', e)
				}
				// if (config.url.indexOf('crm-app/login') !== -1 && !store.state.vuex_token) {
				// 	uni.showToast({
				// 		title: '登录已失效',
				// 		duration: 2000,
				// 		icon: 'none'
				// 	});
				// 	uni.navigateTo({
				// 		url: "/pages/login/login"
				// 	})
				// }
				console.log('helper--interceptor---request-----', config)
				return config;
			},
			// 请求后的拦截
			response: (res) => {
				console.log('helper--iinterceptor---response-----', res)
				if (res.MSGTYPE === 'S' || res.msgtype === 'S' || res.status === 1||res.status === 0 || res.result === "S" ||
					res.Status ===
					'Success') {
					// 如果把originalData设置为了true，这里return回什么，this.$u.post的then回调中就会得到什么
					return res;
				} else {
					uni.showToast({
						title: res.MESSAGE || res.msg || res.message || res.ErrMsg,
						duration: 2000,
						icon: 'none'
					});
					return false
				};
			}
		}

		// get请求
		this.get = (url, data = {}, header = {}) => {
			return this.request({
				method: 'GET',
				url,
				header,
				data
			})
		}

		// post请求
		this.post = (url, data = {}, header = {}) => {
			return this.request({
				url,
				method: 'POST',
				header,
				data
			})
		}

		// put请求，不支持支付宝小程序(HX2.6.15)
		this.put = (url, data = {}, header = {}) => {
			return this.request({
				url,
				method: 'PUT',
				header,
				data
			})
		}

		// delete请求，不支持支付宝和头条小程序(HX2.6.15)
		this.delete = (url, data = {}, header = {}) => {
			return this.request({
				url,
				method: 'DELETE',
				header,
				data
			})
		}
	}
}
export default new Request
