import apiHelper from './api.helper.js'


/**
 * 
 * @param name
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiPurchaseList(params) {
	const res = await apiHelper.post('/crm-app/Invinfo/getUnFinishedInv'+params)
	return res
}
// 以酒促酒
export async function apiGetUnFinishedInvByPromote(params) {
	const res = await apiHelper.post('/crm-app/Invinfo/getUnFinishedInvByPromote'+params)
	return res
}

export async function querySysDictionaryDetailsByCode(params) {
	const res = await apiHelper.post('/crm-app/dictionary/querySysDictionaryDetailsByCode', params, {
		'Content-Type': "application/x-www-form-urlencoded"
	})
	return res
}

export async function getProdDeliveryPlan(params) {
	const res = await apiHelper.post('/crm-app/wantgoods/getProdDeliveryPlan', params)
	return res
}
export async function getReceipt(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/get_bp_sh_addr', params)
	return res
}
export async function findByCustomer(params) {
	const res = await apiHelper.get('/crm-app/setShunting/findByCustomer', params, {'Content-Type': 'application/json'})
	return res
}
export async function findByCustomerWithFilter(params) {
	const res = await apiHelper.post('/crm-app/setShunting/findByCustomerWithFilter', params, {'Content-Type': 'application/json'})
	return res
}
export async function findAppGoodsSingle(params) {
	const res = await apiHelper.post('/crm-app/wantgoods/findAppGoodsSingle', params)
	return res
}
//查询待保存的申请单
export async function findSavedApplyBill(params) {
	const res = await apiHelper.get('/crm-app/wantgoods/findSavedApplyBill')
	return res
}
//查询待保存的申请单详情
export async function findById(params) {
	const res = await apiHelper.post('/crm-app/wantgoods/findById?id=' + params, )
	return res
}
export async function queryLogistics(params) {
	const res = await apiHelper.post('/crm-app/logistics/queryLogistics', params, {'Content-Type': 'application/x-www-form-urlencoded'})
	return res
}
export async function initAppWantGoods(params) {
	const res = await apiHelper.post('/crm-app/wantgoods/initAppWantGoods', params)
	return res
}
export async function getCustomerList(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/bp_search', params)
	return res
}
export async function getChannelType(params) {
	const res = await apiHelper.post('/crm-app/wantgoods/getChannelType', params)
	return res
}
export async function listKAStore(params) {
	const res = await apiHelper.post('/crm-app/kastore/listKAStore', params)
	return res
}
export async function startProcessInstanceByKey(params) {
	const res = await apiHelper.post('/crm-app/workflow/startProcessInstanceByKey', params, {'Content-Type': 'application/x-www-form-urlencoded'})
	return res
}
export async function advance(params) {
	const res = await apiHelper.post('/crm-app/workflow/advance', params, {'Content-Type': 'application/x-www-form-urlencoded'})
	return res
}
// 保存要货单
export async function saveBizData(params) {
	const res = await apiHelper.post('/crm-app/workflow/saveBizData', params, {'Content-Type': 'application/x-www-form-urlencoded'})
	return res
}
export async function getCtrbase(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/get_ctrbase', params)
	return res
}
/**
 * 生成唯一id
 */
export async function generateUUID(params) {
	const res = await apiHelper.get('/crm-app/utils/randomUUID')
	return res
}
/**
 * 公共api
 * 上传附件
 * @param {*} params
 */
export async function webUploadFile(params) {
	const res = await apiHelper.post('/crm-app/webUpload/ajaxUpload', params)
	return res
}
/**
 * 公共api
 * 删除附件
 * @param {*} params
 */
export async function doDeleteFile(params) {
	const res = await apiHelper.post('/crm-app/attachment/doDelete',  params, {'Content-Type': 'application/x-www-form-urlencoded'})
	return res
}
// 获取要货附件
export async function doQuery(params) {
	const res = await apiHelper.post('/crm-app/attachment/doQuery',  params, {'Content-Type': 'application/x-www-form-urlencoded'})
	return res
}
// 下载附件
export async function attachmentDownFile(params) {
	const res = await apiHelper.post('/crm-app/attachmentDownFile',  params)
	return res
}
export async function findShuntAnyByDealer(params) {
	const res = await apiHelper.get('/crm-app/setShunting/findShuntAnyByDealer',  params)
	return res
}
// 查询终端
export async function queryDirectStore(params) {
	const res = await apiHelper.post('/crm-app/storeDealer/queryDirectStore',  params)
	return res
}
// 查询终端要货 历史地址
export async function findFirstByTerminalId(params) {
	const res = await apiHelper.post('/crm-app/wantgoods/findFirstByTerminalId',  params, {'Content-Type': 'application/x-www-form-urlencoded'})
	return res
}
// 查询终端要货箱码
export async function findGoodsSingleJoinBoxBarcode(params) {
	const res = await apiHelper.post('/crm-app/wantGoodsDataQuery/findGoodsSingleJoinBoxBarcode',  params, )
	return res
}
// 终端直配查询子账号
export async function findCustomerByChild(params) {
	const res = await apiHelper.post('/crm-app/wantgoods/findCustomerByChild?childCode='+ params.code)
	return res
}
// 终端直配查询子账号要货单
export async function findChildGoodsSingle(params) {
	const res = await apiHelper.post('/crm-app/wantgoods/findAppChildGoodsSingle',params)
	return res
}
// 判断要货否超月计划数量
export async function exceedMonthPlan(params) {
	const res = await apiHelper.post('/crm-app/wantgoods/exceedMonthPlan',params)
	return res
}
// 放行数量
export async function queryPledgeQuantity(params) {
	const res = await apiHelper.post('/crm-app/wantGoodsDataQuery/anji/queryPledgeQuantity',  params, )
	return res
}