import apiHelper from './api.helper.js'

/**
 * 积分明细查询
 */
export async function fetchDistributerPointEarnPage(params) {
	const res = await apiHelper.post('/crm-app/scm/distributer-point/earn/page', params)
	return res
}

/**
 * 积分使用记录查询
 */
export async function fetchDistributerPointUsePage(params) {
	const res = await apiHelper.post('/crm-app/scm/distributer-point/use/page', params)
	return res
}

/**
 * 积分统计查询
 */
export async function fetchDistributerPointStatistics(params) {
	const res = await apiHelper.post('/crm-app/scm/distributer-point/statistics', params)
	return res
}

/**
 * 积分申请
 */
export async function apiApplyIntegral(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/reverse_int', params)
	return res
}

/**
 * 积分申请查询
 */
export async function getReverseIntegralList(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/get_reverse_int', params)
	return res
}

