import apiHelper from './api.helper.js'

/**
 * 经销商市场支持费用查询。
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetMarketSupportFee(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/get_dealer_msc', params)
	return res
}

/**
 * 经销商账款查询
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiAccountInquiry(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/get_da', params)
	return res
}
