import apiHelper from './api.helper.js'


/**
 * 根据搜索条件查询销售订单信息。
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetSalesOrder(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/get_so', params)
	return res
}

/**
 * 根据销售订单ID查询详情。
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetSalesOrderDetail(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/get_so_by_id', params)
	return res
}
