import apiHelper from './api.helper.js'


/**
 * 
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function addressCheck(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/bp_addr_check', params)
	return res
}
export async function regionOvs(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/region_ovs', params)
	return res
}
export async function cityOvs(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/city_ovs', params)
	return res
}
export async function streetOvs(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/street_ovs', params)
	return res
}
export async function addressImport(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/bp_addr_import', params)
	return res
}
// 终端查询
export async function byDealerConditon(params) {
	const res = await apiHelper.post('/wmdp-storeapp/store/list/byDealerConditon', params)
	return res
}
// 单个终端查询
export async function inboundsById(params) {
	const res = await apiHelper.post('/wmdpwebservices/statistics/terminal/inboundsById', params)
	return res
}
// 嵌入第三方页面校验
export async function getClientByApp(params) {
	const res = await apiHelper.get('/crm-app/platform/getClientByApp', params)
	return res
}
export const getArea = (code, type = 'region', mode) => {
  if (type === 'region') {
    return regionOvs({mode})
  } else if (type === 'city') {
    return cityOvs({ REGION: code, mode })
  } else {
    return streetOvs({ CITY_CODE: code, mode })
  }
}