import apiHelper from './api.helper.js'

/**
 * 根据搜索条件查询材料计划信息。
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetProduceMaterialOrder(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/get_m_plan_app', params)
	return res
}

/**
 * 材料计划创建初始化数据。
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiProduceMaterialPlanInit(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/m_plan_init', params)
	return res
}

/**
 * 材料计划项目更新数据
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiUpdateProduceMaterialPlanData(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/m_plan_update', params)
	return res
}

/**
 * 材料计划单保存。
 * @param 
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiUpdateProduceMaterialOrder(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/materialpln', params)
	return res
}

/**
 * 材料计划单提交。
 * @param 
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiSubmitProduceMaterialOrder(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/materialplnsubm', params)
	return res
}

/**
 * 查询客户可售产品。
 * @param captcha 验证码
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiProductSelect(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/bp_pro_search', params)
	return res
}
