import apiHelper from './api.helper.js'

/**
 * 数据字典单值查询接口
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetDictionary(params) {
	const res = await apiHelper.post('/wmdpwebservices/dictionary/getDictionary', params)
	return res
}

/**
 * 查询所有终端信息
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetTerminal(params) {
	const res = await apiHelper.post('/wmdpwebservices/clue/all/terminal', params)
	return res
}

/**
 * 扫码查询产品信息
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetClueProduct(params) {
	const res = await apiHelper.post('/wmdpwebservices/clue/product', params)
	return res
}

/**
 * 扫码查询经销商信息
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetClueDistributer(params) {
	const res = await apiHelper.post('/wmdpwebservices/clue/distributer', params)
	return res
}

/**
 * 事发战区
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetClueDistributerInfo(params) {
	const res = await apiHelper.post('/wmdpwebservices/clue/distributer/info', params)
	return res
}

/**
 * 线索提交
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiClueSubmit(params) {
	const res = await apiHelper.post('/wmdpwebservices/clue/submit', params)
	return res
}

/**
 * 市场线索查询
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetClueList(params) {
	const res = await apiHelper.post('/wmdpwebservices/clue/search', params)
	return res
}

/**
 * 线索口令查询
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetClueInfoPwdList(params) {
	const res = await apiHelper.post('/wmdpwebservices/clue/info/pwd', params)
	return res
}

/**
 * 线索详情接口
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetClueInfo(params) {
	const res = await apiHelper.post('/wmdpwebservices/clue/info', params)
	return res
}

/**
 * 联络函打款信息列表查询
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetSalesAreaAccountList(params) {
	const res = await apiHelper.post('/wmdpwebservices/salesareaaccountinfo/page/query', params)
	return res
}

/**
 * 经销商待办查询接口
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetMissionList(params) {
	
	// const res = await apiHelper.post('/wmdpwebservices/contactletter/page/query', params)
	const res = await apiHelper.post('/wmdpwebservices/backlog/search/distributer', params)
	return res
}

/**
 * 联络函详情
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetContactLetterDetail(params) {
	const res = await apiHelper.post('/wmdpwebservices/taskassignment/yishang/contactletter/detail', params)
	return res
}

/**
 * 易商-填写收货信息接口
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiDoReceiveInfo(params) {
	const res = await apiHelper.post('/wmdpwebservices/trackInformation/doReceiveInfo', params)
	return res
}

/**
 * 易商-填写收货确认信息接口
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiDoReceiveConfirmInfo(params) {
	const res = await apiHelper.post('/wmdpwebservices/trackInformation/doReceivedConfirmInfo', params)
	return res
}

/**
 * 易商-填写收货罚分申诉信息接口
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiDoReceiveApprovalInfo(params) {
	const res = await apiHelper.post('/wmdpwebservices/closeopinion/approval', params)
	return res
}

/**
 * 查询处理单
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetProcessOrder(params) {
	const res = await apiHelper.post('/wmdpwebservices/processOrder/search', params)
	return res
}

/**
 * 处理单详情查询
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetProcessOrderDetail(params) {
	const res = await apiHelper.post('/wmdpwebservices/processOrder/info', params)
	return res
}

/**
 * 处理单详情发起申诉
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetProcessOrderAppeal(params) {
	const res = await apiHelper.post('/wmdpwebservices/processOrder/trigger/appeal', params)
	return res
}

/**
 * 经销商分利
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function pointsAndCashSummary(params) {
	const res = await apiHelper.post('/wmdpwebservices/statistics/distributer/pointsAndCashSummary', params)
	return res
}
/**
 * 出入库合规累积量
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function queryUnique(params) {
	const res = await apiHelper.post('/wmdpwebservices/general/queryUnique/distributerIn+distributerOut+customerScan+terminalIn', params)
	return res
}
/**
 * selecet list
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function queryProducts(params) {
	const res = await apiHelper.post('/wmdpwebservices/products/query', params)
	return res
}
/**
 * 出入库 查看更多
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function queryScanDistributer(params) {
	const res = await apiHelper.post('/wmdpwebservices/scan/history/distributer', params)
	return res
}
/**
 * 资讯
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function queryNewsListSet(params) {
	const res = await apiHelper.get('/sap/opu/odata/sap/ZODATA_APP_002_SRV_01/NewsListSet', params, {'Content-Type': 'application/json','Accept':'application/json'})
	return res
}
/**
 * 订单动态
 * @returns {Promise<AxiosResponse<T>>}
 */
 export async function querySaleOrder(params) {
	const res = await apiHelper.get('/sap/opu/odata/sap/ZODATA_APP_006_SRV/SODYNSTATSet', params, {'Content-Type': 'application/json','Accept':'application/json'})
	return res
}
/**
 * 最终订单动态
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function findAppWantGoods(params) {
	const res = await apiHelper.post('/crm-app/Invinfo/findAppWantGoods', params, {
	})
	return res
}