import apiHelper from './api.helper.js'

/**
 * 配额酒销售订单初始化数据
 * @param 
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiInitQuotaData(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/so_quota_init', params)
	return res
}

/**
 * 销售订单行项目选择或修改后进行页面数据更新
 * @param 
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiUpdateQuotaData(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/so_u_data_quota', params)
	return res
}

/**
 * 针对配额产品经销商保存、提交、取消、审核配额订单
 * @param 
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiUpdateQuotaOrder(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/so_quota', params)
	return res
}

export default {
	apiInitQuotaData,
	apiUpdateQuotaData,
	apiUpdateQuotaOrder
}
