import apiHelper from './api.helper.js'


/**
 * 根据搜索条件查询生产计划信息。
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetProduceOrder(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/get_p_plan_app', params)
	return res
}

/**
 * 生产计划创建初始化数据。
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiProducePlanInit(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/p_plan_init', params)
	return res
}

/**
 * 生产计划项目更新数据
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiUpdateProducePlanData(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/prodplan05', params)
	return res
}

/**
 * 生产计划单提交。
 * @param 
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiUpdateProduceOrder(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/prodplan003', params)
	return res
}

/**
 * 查询客户可售产品。
 * @param captcha 验证码
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiProductSelect(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/bp_pro_search', params)
	return res
}
