import apiHelper from './api.helper.js'

/**
 * 非配额酒销售订单初始化数据
 * @param 
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiInitNoQuotaData(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/so_noquota_init', params)
	return res
}

/**
 * 销售订单行项目选择或修改后进行页面数据更新
 * @param 
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiUpdateNoQuotaData(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/so_u_data_other', params)
	return res
}

/**
 * 针对配额产品经销商保存、提交、取消、审核配额订单
 * @param 
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiUpdateNoQuotaOrder(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/so_no_quota', params)
	return res
}

export default {
	apiInitNoQuotaData,
	apiUpdateNoQuotaData,
	apiUpdateNoQuotaOrder
}
