import apiHelper from './api.helper.js'

/**
 * 数据字典单值查询接口
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetDictionary(params) {
	const res = await apiHelper.post('/wmdpwebservices/dictionary/getDictionary', params)
	return res
}

/**
 * 查询所有终端信息
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetTerminal(params) {
	const res = await apiHelper.post('/wmdpwebservices/clue/all/terminal', params)
	return res
}

/**
 * 扫码查询产品信息
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetClueProduct(params) {
	const res = await apiHelper.post('/wmdpwebservices/clue/product', params)
	return res
}

/**
 * 扫码查询经销商信息
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetClueDistributer(params) {
	const res = await apiHelper.post('/wmdpwebservices/clue/distributer', params)
	return res
}

/**
 * 线索提交
 * @param name 账户名
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiClueSubmit(params) {
	const res = await apiHelper.post('/wmdpwebservices/clue/submit', params)
	return res
}
