//
//  UUMbsSSOManager.h
//  UUMbsAgentSSO
//
//  Created by xiaoda on 2019/11/4.
//  Copyright © 2019 UUSafe. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class UUMbsAuthParam,UUMbsAgentSSOBuilder;

@interface UUMbsSSOManager : NSObject

/// 获取SSO管理类，注册失败时，返回nil
+ (UUMbsSSOManager * _Nullable)getSSOManager;

/// 标准调用模式，该方法会跳转至Mbs客户端获取数据
/// @param completionHandler 获取数据回调
- (void)auth:(nullable void (^)(UUMbsAuthParam * _Nullable response,NSError *_Nullable error))completionHandler;

/// 授权接口，该接口自动处理refreshToken问题，只有当本地无token或者失效时自动跳转客户端授权
/// 需要在Mbs客户端版本3.5.6之后使用
/// @param completionHandler 完成回调
- (void)authEx:(nullable void (^)(UUMbsAuthParam * _Nullable response,NSError *_Nullable error))completionHandler;

/// 刷新token接口，用户授权之后，调用，该接口会尽量刷新tokekn，否则会跳转客户端重新授权
/// @param refreshToken  第三方客户端维护的refreshToken
/// @param completionHandler 数据回调，username，password 两个参数，此接口不提供。
- (void)refreshToken:(NSString * _Nonnull)refreshToken completionHandler:(nullable void (^)(UUMbsAuthParam * _Nullable response,NSError *_Nullable error))completionHandler;

@end

NS_ASSUME_NONNULL_END
