//
//  UUMbsApiObject.h
//  UUMbsAgent
//
//  Created by xiaoda on 2019/9/23.
//  Copyright © 2019 UUSafe. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

FOUNDATION_EXPORT NSString * const MbsAgentErrorDomain;

/**
 错误码
*/
typedef NS_ENUM(NSInteger, MbsErrCode) {
    MbsSuccess                  = 0,        /**< 成功    */
    MbsErrCodeCommon            = -1,       /**< 普通错误类型    */
    
    MbsErrCodeIllegalOrg        = -2,       /**< 注册错误码  无效机构    */
    MbsErrCodeIllegalClient     = -3,       /**< 注册错误码  无效应用    */
    
    MbsErrCodeUserCancel        = -4,       /**< 授权错误码  用户点击取消并返回    */
    MbsErrCodeDeny              = -5,       /**< 授权错误码  授权失败    */
    MbsErrCodeUnsupport         = -6,       /**< 授权错误码  Mbs不支持    */
    MbsErrCodeTimeOut           = -7,       /**< 授权错误码  授权超时     */
    
    MbsErrCodeOpenMbsError      = -8,       /**< Mbs无法打开   */
    MbsErrCodeSeverError        = -9,       /**< 平台服务地址与SDK不符   */
    
    MbsErrCodeGroupError        = -10,      /**< 同步数据模块，groupId有误   */
    MbsErrCodeSyncSetError      = -11,      /**< 同步数据模块，写入数据失败   */
    MbsErrCodeSecMailCantOpen   = -12,      /**< secmail 无法打开   */
    
    MbsErrCodeSSONotRegister    = -13,      /**< sso MbsAgent未注册   */
    
    MbsErrCodeUnknow            = -10000,   /**< 未知错误   */
    
    MbsErrCodeKeyError          = 10001,    /**< 第三方接入-appkey不正确或无权限  */
    MbsErrCodeSignError         = 10002,    /**< 第三方接入-签名不正确 */
    MbsErrCodeThirdAPPNotAuth   = 10003,    /**< 第三方接入-应用不存在或未授权   */
    MbsErrCodeTokenInvalid      = 10004,    /**< 第三方接入-Token 过期   */
    MbsErrCodeUserNameErr       = 10005     /**< 第三方接入-用户不存在   */
};

typedef NS_ENUM(NSInteger, MbsSecurityType) {
    MbsSecurityNone                     = 0,       /**< 不校验证书    */
    MbsSecurityServer                   = 1,       /**< 只校验服务端证书    */
    MbsSecurityMutualAuth               = 2,       /**< 双向认证    */
};

typedef NS_ENUM(NSInteger, UUMbsStatMode) {
    UUMbsStatModeAuto,          //页面自动统计模式（推荐使用）
    UUMbsStatModeManual         //页面手动统计模式
};

typedef NS_OPTIONS(NSUInteger, UUMbsAgentLogLevelOptions) {
    UUMbsAgentLogLevelOptionsDebugConsole = 1 << 0,     //在debug模式下，输出日志到控制台
    UUMbsAgentLogLevelOptionsReleaseConsole = 1 << 1,   //在release模式下，输出日志到控制台
    UUMbsAgentLogLevelOptionsDebugFile = 1 << 2,        //在debug模式下，输出日志到本地文件
    UUMbsAgentLogLevelOptionsReleaseFile = 1 << 3,      //在release模式下，输出日志到本地文件
    UUMbsAgentLogLevelOptionsAllCorners  = ~0UL
};

@class UUMbsAgentSecurityPolicy;

/**
 MbsAgent 初始化数据对象，初始化时需要使用此对象携带参数
 */
@interface UUMbsAgentBuilder : NSObject

/** orgCode 机构编码*/
@property (nonatomic , copy) NSString *orgCode;
/** ip Mbs 地址*/
@property (nonatomic , copy) NSString *ip;
/** port Mbs 端口*/
@property (nonatomic , copy) NSString *port;
/** appkey 接入账号 (需要从服务器申请)*/
@property (nonatomic , copy) NSString *appKey;
/** 秘钥，需要申请和appkey对应*/
@property (nonatomic , copy) NSString *secretKey;
/** 主程序的程序入口*/
@property (nonatomic , copy) NSString *hostScheme;
/** 客户端程序入口*/
@property (nonatomic , copy) NSString *clientScheme;
/// 网络校验类型（默认不校验）
@property (nonatomic , assign) MbsSecurityType securityType;
/// 服务端校验信息
@property (nonatomic,strong) UUMbsAgentSecurityPolicy *serverSecurityPolicy;
/// 客户端校验信息
@property (nonatomic,strong) UUMbsAgentSecurityPolicy *clientSecurityPolicy;

@end


/**
 MbsAgentStat 初始化数据对象，初始化时需要使用此对象携带参数
 */
@interface UUMbsAgentStatBuilder : NSObject

/** orgCode 机构编码*/
@property (nonatomic , copy) NSString *orgCode;
/** ip Mbs 地址*/
@property (nonatomic , copy) NSString *ip;
/** port Mbs 端口*/
@property (nonatomic , copy) NSString *port;
/** 应用版本,默认为 [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleShortVersionString"] */
@property (nonatomic , copy) NSString *versionCode;
/** 设备唯一标识，第三方应用自主生成 */
@property (nonatomic , copy) NSString *securityId;
/** 应用id,默认为 [NSBundle mainBundle].bundleIdentifier   */
@property (nonatomic , copy) NSString *bundleIdentifier;
/** 是否为基座客户端，默认为NO */
@property (nonatomic , assign) BOOL isMbsPlatform;

@property (nonatomic , assign) UUMbsStatMode statMode;

@end

/**
 SSO 标准授权，返回的数据对象
 */
@interface UUMbsAuthParam : NSObject

/** 应用token */
@property (nonatomic , copy) NSString *accessToken;
/** 接入token超时时间，单位秒 */
@property (nonatomic , assign) int64_t accessTokenTimeout;
/** 刷新令牌 */
@property (nonatomic , copy) NSString *refreshToken;
/** 刷新令牌超时时间，单位秒  */
@property (nonatomic , assign) int64_t refreshTokenTimeout;
/** 用户名*/
@property (nonatomic , copy) NSString *username;
/** 密码md5值*/
@property (nonatomic , copy) NSString *password;
/** 服务器返回凭证产生时间戳，单位毫秒，long类型  */
@property (nonatomic , assign) int64_t timestamp;
/** mbs主程序token值，需第三方应用妥善保存，否则可能出现恶意获取token后导致的用户数据泄漏、用户Mbs相关接口功能被恶意发起等行为 */
@property (nonatomic , copy) NSString *mbsToken;

@end


/// 双向校验对象
@interface UUMbsAgentSecurityPolicy : NSObject

/** 证书校验信息 */
@property (nonatomic,strong) NSData *PKCS12Data;
/** 证书校验密码 */
@property (nonatomic,copy) NSString *password;
/**
 Whether or not to trust servers with an invalid or expired SSL certificates. Defaults to `NO`.
 */
@property (nonatomic,assign) BOOL allowInvalidCertificates;
/**
 Whether or not to validate the domain name in the certificate's CN field. Defaults to `YES`.
 */
@property (nonatomic,assign) BOOL validatesDomainName;

@end


/// 数据同步对象
@interface UUMbsAgentSyncBuilder : NSObject

/** 邮件同步状态 */
@property (nonatomic,strong) NSString *secMailSyncConfig;

@end
