//
//  UUMbsAgent.h
//  UUMbsAgent
//
//  Created by xiaoda on 2019/9/23.
//  Copyright © 2019 UUSafe. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "UUMbsApiObject.h"

/// UUSafe 开放平台
@interface UUMbsAgent : NSObject

/// 注册Mbs终端注册第三方程序应用
/// @param builder agent 注册参数对象
/// @param completionHandler 注册接口回调
+ (void)registerWithBuilder:(UUMbsAgentBuilder * _Nonnull)builder
          completionHandler:(nullable void (^)(NSError *_Nullable error))completionHandler;

/// 注册Mbs终端注册第三方程序应用（主程序内核版本在3.5.6之后使用）
/// @param builder agent 注册参数对象
+ (BOOL)registerWithBuilderEx:(UUMbsAgentBuilder * _Nonnull)builder;
           
/// 处理Mbs客户端程序通过URL启动第三方应用时传递的数据
/// 需要在 `application:openURL:sourceApplication:annotation:`或者`application:handleOpenURL`中调用
/// @param url 启动第三方应用的URL
+ (void)handleOpenURL:(NSURL * _Nullable)url;

/// 检测主程序Mbs是否安装，此方法需要在info.plist中添加scheme白名单
/// @param scheme 主程序的程序入口名
+ (BOOL)isMbsInstalled:(NSString * _Nullable)scheme;

/// 获取MbsAgent 版本号,当前版本号 3.6.2
+ (NSString * _Nonnull)getVersion;

/// 设置是否在控制台中打印SDK中的日志，用于调试,仅在 debug模式下生效，默认值 NO
+ (void)enableDebugOn:(BOOL)on NS_DEPRECATED_IOS(1_0, 1_2, "3.6.2 版本以后使用 `setLogLevel` 方法替代。");

/// 设置日志等级，可以控制日志的输出范围
/// @param logLevelOptions 日志等级
+ (void)setMbsAgentLogLevel:(UUMbsAgentLogLevelOptions)logLevelOptions;

/// 获取日志文件路径数组，开发者可以压缩后使用 UIDocumentInteractionController 导出，详见demo
+ (NSArray * _Nullable)getMbsAgentLogs;

@end
