import apiHelper from './api.helper.js'

/**
 * 公关团购销售订单初始化数据
 * @param 
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiInitGroupData(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/so_ggtg_init', params)
	return res
}

/**
 * 销售订单行项目选择或修改后进行页面数据更新
 * @param 
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiUpdateGroupData(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/so_u_data_ggtg', params)
	return res
}

/**
 * 针对非配额产品经销商保存、提交、取消、审核配额订单。
 * @param 
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiUpdateGroupOrder(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/so_ggtg', params)
	return res
}

export default {
	apiInitGroupData,
	apiUpdateGroupData,
	apiUpdateGroupOrder
}
