import apiHelper from './api.helper.js'

/**
 * 产品查询
 * @param captcha 验证码
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiProductSelect(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/product_ovs', params)
	return res
}

/**
 * 销售计划查询
 * @param password 账户密码
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiSalesPlanSelect(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/sales_plan_ovs', params)
	return res
}

/**
 * 获取销售计划类型
 * @param captcha 验证码
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiSalesPlanTypesSelect(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/sp_type_ovs', params)
	return res
}

/**
 * 团购单位信息查询
 * @param captcha 验证码
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGroupClientSelect(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/grputid_ovs', params)
	return res
}

/**
 * 输入团购单位名称后可进行商机编号查询
 * @param captcha 验证码
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiBusinessSelect(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/busoppid_ovs', params)
	return res
}

/**
 * 输入订单客户编号和团购单位后可进行收货方信息查询
 * @param captcha 验证码
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiAddressSelect(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/transdata/partner_ovs', params)
	return res
}

/**
 * 客户订单和制票金额查询。
 * @param captcha 验证码
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetBpPrice(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/masterdata/get_price_by_bp', params)
	return res
}

/**
 * 根据客户编号查询订单执行情况
 * @param captcha 验证码
 * @returns {Promise<AxiosResponse<T>>}
 */
export async function apiGetHomeStatistics(params) {
	const res = await apiHelper.post('/sap/bc/ztpm/to_new_crm/masterdata/get_table_by_bp', params)
	return res
}

export default {
	apiProductSelect,
	apiSalesPlanSelect,
	apiGroupClientSelect,
	apiBusinessSelect,
	apiAddressSelect
}
