// webpack.config.js
const path = require('path')

module.exports = {
  lintOnSave: false,
  publicPath: process.env.NODE_ENV === 'production' ? '/qywx/' : '',
  css: {
    loaderOptions: {
      sass: {
        // 全局引入变量和 mixin
        additionalData: `
              @import "@/assets/styles/variable.scss";
              @import "@/assets/styles/mixin.scss";
            `
      }
    }
  },
  devServer: {
    proxy: {
      '/huigou': {
        target: 'http://221.10.127.60:5000',
        // target: 'http://10.2.7.85',
        changeOrigin: true,
        pathRewrite: {
          '^/huigou': '/crm-app' // 重写,
        }
      }
    }
  },
  productionSourceMap: false,
  // 文件名添加hash，避免企业微信缓存问题
  filenameHashing: true,
  configureWebpack: {
    resolve: {
      alias: {
        '@': path.resolve(__dirname, './src'),
        '@img': path.resolve(__dirname, './src/assets/images')
      }
    },
    plugins: [],
    output: {
      // 确保文件名包含hash
      filename: process.env.NODE_ENV === 'production' ? 'js/[name].[contenthash:8].js' : 'js/[name].js',
      chunkFilename: process.env.NODE_ENV === 'production' ? 'js/[name].[contenthash:8].js' : 'js/[name].js'
    }
  }
}
