import request from '@/utils/request'
import { BASE_API } from '@/api/baseUrl'
import { handleFormData } from '@/utils/index'

export function handlerFlow(data, key) {
  if (data.id) {
    return saveData(data)
  } else {
    return startProcessInstanceByKey(data, key)
  }
}

/**
 * 保存业务数据
 */
export function saveData(data) {
  return request({
    url: BASE_API() + '/workflow/saveBizData',
    method: 'post',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded'
    },
    data: handleFormData(data)
  })
}

/**
 * 退回
 */
export function backToApplyActivity(data) {
  return request({
    url: BASE_API() + '/workflow/backToApplyActivity',
    method: 'post',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded'
    },
    data: handleFormData(data)
  })
}

/**
 * 任务列表
 */
export function taskExecutionFindByBizId(params) {
  return request({
    url: BASE_API() + '/workflow/taskExecution/findByBizId',
    method: 'get',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded'
    },
    params
  })
}

/**
 * 启动流程
 */
export function startProcessInstanceByKey(data, key) {
  data.processDefinitionKey = key
  data.processAction = 'save'
  data.flowKind = 'APPROVAL'
  data.procUnitId = data.id ? 'APPROVE' : 'APPLY'

  return request({
    url: BASE_API() + '/workflow/startProcessInstanceByKey',
    method: 'post',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded'
    },
    data: handleFormData(data)
  })
}
/**
 * 提交流程
 */
export function advance(data) {
  data.procUnitId = 'approve'
  data.processAction = 'advance'
  return request({
    url: BASE_API() + '/workflow/advance',
    method: 'post',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded'
    },
    data: handleFormData(data)
  })
}
/**
 * 页面离开
 */
export function editFlowTest(data) {
  return request({
    url: BASE_API() + '/flowTest/editFlowTest',
    method: 'post',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded'
    },
    data
  })
}
/**
 * 流程轨迹
 */
export function queryApprovalHistoryByBizId(data) {
  return request({
    url: BASE_API() + '/workflow/queryApprovalHistoryByBizId',
    method: 'post',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded'
    },
    data: handleFormData(data)
  })
}
