import Cookies from 'js-cookie'

// 是否需要前缀
const HEADER_TOKEN_KEY = 'X-Auth-Token'

/**
 * 获取token
 */
const getToken = function () {
  return Cookies.get(HEADER_TOKEN_KEY)
}
/**
 * 设置token
 */
const setToken = function (token) {
  return Cookies.set(HEADER_TOKEN_KEY, token)
}

/**
 * 删除token
 */
const clearToken = function () {
  return Cookies.remove(HEADER_TOKEN_KEY)
}

export { HEADER_TOKEN_KEY, getToken, setToken, clearToken }
