import { createRouter, createWebHashHistory } from 'vue-router'

export const globalRouter = [
  {
    path: '/login',
    name: 'Login',
    component: () => import('@/views/Login.vue')
  },
  {
    path: '',
    name: 'MonthFlow2',
    component: () => import('@/views/month-flow/monthFlow.vue')
  },
  {
    path: '/month-flow',
    name: 'MonthFlow',
    component: () => import('@/views/month-flow/monthFlow.vue')
  },
  {
    path: '/plan-change-flow',
    name: 'PlanChangeFlow',
    component: () => import('@/views/plan-change-flow/PlanChangeFlow.vue')
  },
  {
    path: '/ship-approval',
    name: 'ShipApproval',
    component: () => import('@/views/ship-approval/ShipApproval.vue'),
    meta: {
      noCache: true // 标记为不缓存
    }
  },
  {
    path: '/invoice-occupancy-detail',
    name: 'InvoiceOccupancyDetail',
    component: () => import('@/views/invoice-occupancy-detail/InvoiceOccupancyDetail.vue')
  }
]

const router = createRouter({
  history: createWebHashHistory(),
  routes: globalRouter
})

export function resetRouter() {
  const newRouter = router
  router.matcher = newRouter.matcher // reset router
}

export default router
