import request from '@/utils/request'
import { BASE_API } from '@/api/baseUrl'

/**
 * 登录
 * @param {*} params
 */
export function login(data) {
  return request({
    url: BASE_API() + '/login',
    method: 'post',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded'
    },
    data: data
  })
}

/**
 * 登出
 * @param {*} params
 */
export function logout(data) {
  return request({
    url: BASE_API() + '/logout',
    method: 'post',
    data: data
  })
}
