// 判断是什么设备
export const isH5OrPc = () => {
  if (/Mobile|Android|webOS|iPhone|iPad|Phone/i.test(navigator.userAgent)) {
    return 'H5'
  }
  return 'PC'
}

/**
 * @param {string} url
 * @returns {Object}
 */
export function getQueryObject(url) {
  url = url == null ? window.location.href : url
  const search = url.substring(url.lastIndexOf('?') + 1)
  const obj = {}
  const reg = /([^?&=]+)=([^?&=]*)/g
  search.replace(reg, (rs, $1, $2) => {
    const name = decodeURIComponent($1)
    let val = decodeURIComponent($2)
    val = String(val)
    obj[name] = val
    return rs
  })
  return obj
}

// 处理流程提交数据
export function handleFormData(data) {
  const formData = new FormData()

  for (const key in data) {
    if (typeof data[key] === 'object' && data[key] !== null) {
      formData.append(key, JSON.stringify(data[key]))
    } else if (data[key] === null) {
      formData.append(key, '')
    } else {
      formData.append(key, data[key])
    }
  }

  return formData
}

/**
 * 下载
 */
export function download(data, fileName, responseType = 'application/octet-stream') {
  const blob = data instanceof Blob ? data : new Blob([data], { type: responseType })
  if ('download' in document.createElement('a')) {
    // 非IE下载
    const url = window.URL.createObjectURL(blob)
    const link = document.createElement('a')
    link.style.display = 'none'
    link.href = url
    link.setAttribute('download', fileName)
    document.body.appendChild(link)
    link.click()
    window.URL.revokeObjectURL(link.href)
    document.body.removeChild(link)
  } else {
    // IE10+下载
    navigator.msSaveBlob(blob, fileName)
  }
}
